% Sets Model Parameters for any period
function model = model_setup(t)


% industry ordering:
%   1) construction
%   2) durable goods
%   3) IPP services
%   4) nondurable goods
%   5) services

matdir = 'Output/';

% -- Calibration -- %
params            = load([matdir 'observable_parameters.mat']);
drv_proc          = load([matdir 'driving_processes.mat']);

% investment technologies
%   durable goods and IPP are in first sub-bundle
ind1_inv                = [2 3];
ind2_inv                = [1 4:5];
rho_x                   = params.rho_x;       % CES for investment bundle
epsilon_x               = drv_proc.eps_x;     % CES for investment sub-bundle 1
eta_x                   = NaN(5,5);           % 'shares' for investment sub-bundle 1, time-varying 
eta_x(ind1_inv(1),:)    = drv_proc.trend_eta_x(t,:);
eta_x(ind1_inv(2),:)    = 1- drv_proc.trend_eta_x(t,:);
zeta_x                  = NaN(5,5);           % 'shares' for investment sub-bundle 2
zeta_x(ind2_inv,:)      = params.zeta_x;

% materials technologies
%   durable goods and IPP are in first sub-bundle
ind1_mat                = [2 3];
ind2_mat                = [1 4:5];
rho_m                   = params.rho_m;       % CES for materials bundle
epsilon_m               = drv_proc.eps_m;     % CES for investment sub-bundle 1
eta_m                   = NaN(5,5);           % 'shares' for investment sub-bundle 1 
eta_m(ind1_mat(1),:)    = drv_proc.trend_eta_m(t,:);
eta_m(ind1_mat(2),:)    = 1-drv_proc.trend_eta_m(t,:);
zeta_m                  = NaN(5,5);           % 'shares' for investment sub-bundle 2
zeta_m(ind2_mat,:)      = params.zeta_m;

% final goods technologies
gamma_y                 = params.gamma_j; 

% value added technologies
alpha                   = params.alpha_j';  % capital in value added shares
delta                   = params.delta_j';  % depreciation rates

% preferences
%   non-durables and services in second sub-bundle
ind1_c              = 1:3;
ind2_c              = [4 5];
sigma               = drv_proc.sigma;             % preference
beta                = params.beta;                % discount factor
zeta_c              = NaN(5,1);                   % consumption shares
zeta_c(ind1_c)      = params.zeta_c;
Theta_c             = NaN(5,1);                   % non-homothetic preference weights
Theta_c(ind2_c)     = [1 drv_proc.trend_Theta_t(t)];
epsilon_c           = NaN(5,1);                   % CES for non-homothetic preferences
epsilon_c(ind2_c)   = [1 drv_proc.epsilon_c];
s_c                 = params.s_c;
ratio_en_pyb        = drv_proc.ratio_en_pyb(t);


% -- Tech and Labor -- %
gamma_l = 1;


% -- Save Output -- %
model.eta_x         = eta_x;
model.epsilon_x     = epsilon_x;
model.rho_x         = rho_x;
model.zeta_x        = zeta_x;
model.ind1_inv      = ind1_inv;
model.ind2_inv      = ind2_inv;
model.eta_m         = eta_m;
model.epsilon_m     = epsilon_m;
model.rho_m         = rho_m;
model.zeta_m        = zeta_m;
model.ind1_mat      = ind1_mat;
model.ind2_mat      = ind2_mat;
model.gamma_y       = gamma_y;
model.beta          = beta;
model.delta         = delta;
model.alpha         = alpha;
model.ratio_en_pyb  = ratio_en_pyb;
model.s_c           = s_c;
model.gamma_l       = gamma_l;
model.zeta_c        = zeta_c;
model.Theta_c       = Theta_c;
model.sigma         = sigma;
model.epsilon_c     = epsilon_c;
model.ind1_c        = ind1_c;
model.ind2_c        = ind2_c;
